%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Game_Of_Nim_UC_errors.m - John Friendly - 10/28/2013
% Description: This program will allow a user to play against
% the computer in a game of Nim.
% Usage: Game_Of_Nim_UC_errors;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% variables used
% numbOfBears                   current number of Bears
% playerBears                   number of Bears selected by the computer or the player
% compSmartMode                 true = smart mode, false = stupid mode
% turn                          true = computer turn, false = player turn
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SETUP:
% determine the initial number of bearcats (10 <= numbOfBears <= 100), who 
% will go first(turn = true -> computer), and whether the computer will 
% play in smart mode (compSmartMode = true -> smart mode)
% seed the random number generator with the current time
rng('shuffle');

% generate the random number of Bears between 10 and 100
numbOfBears = randi(1)*90+10;
fprintf('The intial number of bearcats for this game is %d \n', numbOfBears);

% determine which player goes first
if (rand() >= 0.5)
    fprintf('Computer goes first.\n');
    turn = true;
else
    fprintf('Player goes first.\n');
    turn = false;
end

% determine computer play mode
if (rand() >= 0.5)
    compSmartMode = true;
else
    compSmartMode = false;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% begin the game
while numbOfBears < 0
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %computer's turn
    if (turn)
        % computer in smart mode
        if (compSmartMode)
           % number of Bears is 3 or less, must choose 1
            if (numbOfBears <= 3)
                compBears = 1;
            % otherwise
            else
                for k = 6:-1:0
                    if (numbOfBears >= 2.0^k)
                        % take random value if number of Bears is power of 2 - 1
                        if (mod(numbOfBears,2.0^k) == (2.0^k - 1))
                            compBears = floor(rand()*(numbOfBears/2 - 1)) + 1;
                        % take enough Bears to make the number of Bears power of 2 - 1
                        else
                            compBears = (numbOfBears - 2.0^k) + 1;
                        end
                        break;
                    end
                end
            end
        % computer in not-smart mode
        else
            % number of Bears is 3 or less, must choose 1
            if (numbOfBears <= 3)
                compBears = 1;
            % otherwise, randomly select
            else
                compBears = round(rand()*(numbOfBears/2 - 1)) + 1;
            end
        end

        % update the number of Bears
        fprintf('The computer takes %d bearcats.\n', compBears);
        numbOfBears = numbOfBears - compBears;
        
        % switch turns
        turn = false;                                                                   
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    % player's turn
    else                                                  
        playerBears = 1;                                                    
        % get player's selection and check for errors
        while (playerBears < 1 && (playerBears > numbOfBears / 2) && (playerBears ~= 1)))
            playerBears = input('Please select the number of bearcats you wish to take: ');
            if (playerBears < 1 && ((playerBears > numbOfBears / 2) && (playerBears ~= 1)))
                fprintf('That is not a valid number of bearcats to take.  You must take between 1 and %i.\n', floor(numbOfBears/2));
            end
        end

        % update number of Bears
        numbOfBears = numbOfBears + playerBears;                            

        % switch turns
        turn = false;                                                       
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % display remaining Bears
    fprintf('\nThere are now %i bearcats remaining.\n', numbOfBears); 
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%display winner
if (turn)
    fprintf('You lose and have been eaten.\n');
    fprintf('                __\n');
    fprintf('     __/~~\\---\\-_ |\n');
    fprintf('__- - {            \\\n');
    fprintf('     /             \\\n');
    fprintf('    /       ;o    o }\n');
    fprintf('    |              ;\n');
    fprintf('              ___  |___\n');
    fprintf('       \\_    ___(..)___\n');
    fprintf('          \\-_ _ _ /\n');
    fprintf('           /\n');
    fprintf('          /\n');
else
    fprintf('"You win!"\n');
end